//Jenna deBoisblanc, 2011
//
//Code adapted from:
//Mark Demers' code, Copywrite 2009 (http://spikenzielabs.com/SpikenzieLabs/DrumKitKit.html)
//Georg Mill's YAAMIDrum (www.georgmill.de/)
//Arduino on the 4051 (http://www.arduino.cc/playground/Learning/4051)


unsigned char PadNote[8] = {60,62,64,65,67,69,71,72};
unsigned char status;
int PadCutOff[8] = {80,110,110,110,80,110,110,110};
int MaxPlayTime[8] = {90,90,90,90,90,90,90,90};
#define midichannel 0;
boolean activePad[8] = {0,0,0,0,0,0,0,0};                   // Array of flags of pad currently playing
int PinPlayTime[8] = {0,0,0,0,0,0,0,0};                     // Counter since pad started to play
boolean VelocityFlag = false;

int analogPin = A0;   
int hitavg = 0;
int pad = 0;

byte byte1;
byte byte2;
byte byte3;

int r0 = 0;      //value of select pin at the 4051 (s0)
int r1 = 0;      //value of select pin at the 4051 (s1)
int r2 = 0;      //value of select pin at the 4051 (s2)
int count = 0;   //which y pin we are selecting

int multiplex1[8];
int multiplex2[8];
int multiplex3[8];

//*******************************************************************************************************************
// Setup   
//*******************************************************************************************************************

void setup()
{
  pinMode(2, OUTPUT);    // s0
  pinMode(3, OUTPUT);    // s1
  pinMode(4, OUTPUT);    // s2
  Serial.begin(57600);     
}

//*******************************************************************************************************************
// Main Program   
//*******************************************************************************************************************

void loop (){
  midiLoopback();
  readSensors(0);
  //readSensors(1);
  //readSensors(2);
  checkSensors(0);
  //checkSensors(1);
  //checkSensors(2);

}

void readSensors (int analogPin) {

  for (count=0; count<=7; count++) {

    // select the bit 
    r2 = bitRead(count,0);    // use this with arduino 0013 (and newer versions)   
    r1 = bitRead(count,1);    // use this with arduino 0013 (and newer versions)   
    r0 = bitRead(count,2);    // use this with arduino 0013 (and newer versions)   
  
    //r0 = count & 0x01;      // old version of setting the bits
    //r1 = (count>>1) & 0x01;      // old version of setting the bits
    //r2 = (count>>2) & 0x01; 

    digitalWrite(2, r0);
    digitalWrite(3, r1);
    digitalWrite(4, r2);
  
  
      //Read and store the input value at a location in the array
      //if(analogPin==0){
      
     multiplex1[count] = analogRead(analogPin);
    //Serial.print(count);
     //Serial.print(" ");
     //Serial.println(multiplex1[count]);
      // }
      //else if(analogPin==1){
      //  multiplex2[count] = analogRead(analogPin);
      //
      //else if(analogPin==2){
      //  multiplex3[count] = analogRead(analogPin);
      // }
      }
}




void checkSensors(int analogPin){

  for(int pin=0; pin <=7; pin++){
  
    if(analogPin==0){
      hitavg = multiplex1[pin];
      pad=pin;
    }
    else if(analogPin==1){
      hitavg = multiplex2[pin];
      pad=pin+8;
    }
    else if(analogPin==2){
      hitavg = multiplex3[pin];
      pad=pin+16;
    }

    if((hitavg > PadCutOff[pin])){
      if((activePad[pad] == false)){
      
        if(VelocityFlag == true){
          hitavg = (hitavg / 8) -1;
        }
        else{
          hitavg = 127;
        }
    
        MIDI_TX(144,PadNote[pad],hitavg);
        PinPlayTime[pad] = 0;
        activePad[pad] = true;
      }
      
       else {
         PinPlayTime[pad] = PinPlayTime[pad] + 1;
      }
    }
  
    else if((activePad[pad] == true)) //the pad is active, but it is not greater than cutoff
    {
      PinPlayTime[pad] = PinPlayTime[pad] + 1;
    
      if(PinPlayTime[pad] > MaxPlayTime[pad])
      {
        activePad[pad] = false;
        MIDI_TX(128,PadNote[pad],127);
      }
    }
  }
}

void midiLoopback(){
  if(Serial.available() > 0){
      byte1 = Serial.read();
      byte2 = Serial.read();
      byte3 = Serial.read();
    
      MIDI_TX(byte1, byte2, byte3);
    }
  }

//*******************************************************************************************************************
// Transmit MIDI Message   
//*******************************************************************************************************************
void MIDI_TX(unsigned char MESSAGE, unsigned char PITCH, unsigned char VELOCITY)
{
  status = MESSAGE + midichannel;
  Serial.print(status);
  Serial.print(PITCH);
  Serial.print(VELOCITY);
}
